/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.servlet.logd;

import com.ibm.hwmca.base.util.BaseTextBundle;
import com.ibm.hwmca.fw.servlet.logd.FormatTextData;
import com.ibm.hwmca.fw.servlet.logd.IssueCmd;
import com.ibm.hwmca.fw.servlet.logd.LogServlet;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.io.PrintWriter;

public class GetRefcodeDesc {
    private static final String TRACE_MASKT = "XLDSREFT";
    private static final String TRACE_MASKF = "XLDSREFF";
    private static final String TRACE_MASKD = "XLSDREFD";
    private static final String _refcodeTitle = new LocalizableText(BaseTextBundle.getBundleName(), "xlds.refcode.title").toString();
    private static final int REFCODE_LENGTH = 8;
    private static final LocalizableText _lRefcodeDesc = new LocalizableText(BaseTextBundle.getBundleName(), "logd.refcode.title");

    public static String getRefcodeDesc(String refcode) throws IOException {
        Trace.trace(TRACE_MASKT, "-> GetRefcodeDesc.getRefcodeDesc()");
        int refcodeLen = refcode.length();
        if (refcodeLen > 8) {
            refcode = refcode.substring(0, 8);
        }
        String cmd = "bbresrc " + refcode;
        Trace.trace(TRACE_MASKF, "before getRefcodeDescCmd=" + cmd);
        String refcodeDesc = null;
        try {
            refcodeDesc = IssueCmd.execute(cmd);
            Trace.trace(TRACE_MASKF, "after getRefcodeDescCmd=" + cmd);
        }
        catch (IOException ioe) {
            Trace.trace(TRACE_MASKF, "error retrieving refcode desc, will return not found");
            Trace.trace(TRACE_MASKF, ioe);
        }
        if (refcodeDesc == null || refcodeDesc.length() == 0) {
            refcodeDesc = "Refcode description not found.";
        }
        String formattedRefcodeDesc = FormatTextData.createText(refcodeDesc, false);
        Trace.trace(TRACE_MASKT, "<- GetRefcodeDesc.getRefcodeDesc()");
        return formattedRefcodeDesc;
    }

    public static void displayRefcodeDesc(PrintWriter out, String refcodeDesc) throws IOException {
        Trace.trace(TRACE_MASKT, "-> GetRefcodeDesc.displayRefcodeDesc()");
        out.print("<html> <script src='/js/servlettask/keys.js'></script><head><title>" + _refcodeTitle + "</title></head>" + "<body onload='window.focus(); hideCancel();' > <pre>" + LogServlet.HTML_BACK + "<br>&nbsp;<br>" + refcodeDesc + "</pre> </body>" + "</html>");
        Trace.trace(TRACE_MASKT, "-> GetRefcodeDesc.displayRefcodeDesc()");
    }
}

